#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform vec2 iResolution;
uniform float iGlobalTime;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 iMouse = vec4(0.0);
#define MAX_STEPS 100.
#define MAX_DISTANCE 16.0
#define epsilon 0.01
#define infinite 1e7
#define MAX_REFLECTIONS 2.
#define lightSize 1.4
#define powLight 4.0
#define lightColor vec3(0.3,0.6,0.3)
vec3 lightSource = vec3( -10,  15., 10.);

mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float smin( float a, float b, float k ) {
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    q=q.zxy;
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t )
{
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float getColorReflection( vec3 position, out vec3 color, out float reflectiveValue) {
    vec3 _position = position;
    float dist = 1e8;
    
    dist = min(dist, sdBox(position-vec3(0.0,-3.0,0.0),vec3(11.,1.,11.)));
    float dist2 = 1e8;
    dist = min(dist, sdSphere(position-vec3(cos(iGlobalTime)*6., abs(sin(iGlobalTime*2.)*2.),sin(iGlobalTime)*6.),2.0));
    
    dist2 = min(dist2, sdSphere(position-vec3(-cos(iGlobalTime)*6., abs(sin(iGlobalTime*2.4)*2.),-sin(iGlobalTime)*6.),2.0));
    
    
    position *= rotationMatrix(vec3(cos(iGlobalTime*3.)/2.,0.0,sin(iGlobalTime*3.)/2.),0.3);
    dist = min(dist, sdCappedCylinder(position ,vec2(3.0,0.4)));
    dist = max(dist, -sdCappedCylinder(position ,vec2(2.5,0.41)));
    dist = min(dist, sdBox(_position-vec3(0.1,-3.0,0.0),vec3(.3,4.,.3)));
    dist = min(dist, sdBox(_position-vec3(0.0,-3.0,0.4),vec3(.3,6.,.3)));
    dist = min(dist, sdBox(_position-vec3(-0.2,-3.0,0.2),vec3(.3,8.,.3)));
    color = vec3( 0.4, 0.8, 0.9);
    
    reflectiveValue = 0.8;
    if(dist2 < dist) {
        dist=dist2;
        color = vec3( 0.7,0.04,0.04);
    
        reflectiveValue = 0.03;
    }
    
    return dist;
}
float getDistance( in vec3 position) {
    vec3 _position = position;
    vec3 c;
    float r;
    return getColorReflection(_position, c, r);
}
vec3 getSurfaceNormal(vec3 position) {
    float e=epsilon;
    vec3 normalVector = vec3(
                            getDistance(position+vec3( e,  0., 0.)) - getDistance(position+vec3(  -e,   0.,  0.)) ,
                            getDistance(position+vec3( 0., e,  0.)) - getDistance(position+vec3(   0., -e,   0.)) ,
                            getDistance(position+vec3( 0., 0., e)) - getDistance(position+vec3(    0.,  0., -e)) );
    normalVector = normalize(normalVector);
    return normalVector;
}
float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.03;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<33; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.001) break;
    }
    return clamp(res,0.07,9.0);
}
float getSurfaceColor( vec3 curPosition, vec3 normalVector, vec3 lightSource, vec3 lightDirection) {
    float intensity = lightSize * pow( 0.001 + max(0.0, dot( lightDirection, normalVector)),  powLight);
    intensity = lightSize * pow( intensity / distance( curPosition, lightSource),  powLight);
    intensity += pow (max( dot( normalize( lightSource - curPosition), normalVector), 0.0), powLight);
    return intensity;
}
vec4 passTrace(vec3 rayOrigin, vec3 rayDirection, out vec3 inside_colored) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    float finalLight = 1.0;
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    float globalIllumination=0.;
    float lengthGone = 0.0;
        for(float i = 0.; i < MAX_STEPS; i++) {
            float stepable = getDistance( curPosition);
      
            curPosition += 0.05 * rayDirection;
            lengthGone += 0.05;
            vec3 sLight = lightColor  * distance(curPosition, lightSource);
            inside_colored += 0.05 * lightSize * sLight / (1.0 + pow( distance(lightSource, curPosition) ,  powLight) );
            if( getDistance( curPosition) > epsilon) {
                break;
            } 
            /*too far from begining  point, call it an end*/
            if( distance( prevPosition.xy, curPosition.xy) > MAX_DISTANCE) {
                break;
            }
        }
    inside_colored = inside_colored * lengthGone * 0.0001;
    return vec4( curPosition, distance(prevPosition,curPosition));
}
vec4 oneTrace(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    
        for(float i = 0.; i < MAX_STEPS/2.; i++) {
            float stepable = getDistance( curPosition);
      
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;

            endColorResult += finalLight/(1.0+1.2*pow(distance( curPosition, lightSource),powLight/2.0));

           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float reflection = 0.0;
                getColorReflection( curPosition, color, reflection);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.3;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
               
                vec3 sLight = ( lightColor * surfaceBrightness );
                vec3 lightColorInside = color + finalLight * lightColor;
                
                
                vec3 currentColorRecivial = vec3(0.0);
                
                float surfaceColor = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                
                currentColorRecivial += surfaceColor
                                    * ( lightColor * (1.0 - surfaceBrightness) + vec3(1.0) * surfaceBrightness )
                                        * min(max(color * storeColorStrength, vec3(0.0)),vec3(1.0));
                
                currentColorRecivial += currentColorRecivial;
                endColorResult += storeColorStrength * currentColorRecivial;
                storeColorStrength *= reflection;
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition) > MAX_DISTANCE) {
                break;
            }
        }
    
    return vec4( endColorResult, 1.);
}
vec4 march(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    float hit = 0.0;
    float distanceOfCollision = 1111110.;
    for(float reflection = 0.; reflection < MAX_REFLECTIONS; reflection++) {
        for(float i = 0.; i < MAX_STEPS; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;

           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float reflection = 0.0;
                getColorReflection( curPosition, color, reflection);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.9;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
               
                vec3 sLight = ( lightColor * surfaceBrightness );
                vec3 lightColorInside = color + finalLight * lightColor;
                
                
                vec3 currentColorRecivial = vec3(0.0);
                
                vec4 pos_ilum = passTrace( curPosition + epsilon * rayDirection, rayDirection*rotationMatrix(normalVector,0.5), lightColorInside);
                currentColorRecivial +=
                    ( lightColorInside +
                    storeColorStrength * 
                    color * 
                    oneTrace(pos_ilum.xyz + 2. * epsilon * rayDirection, rayDirection).rgb ) / (1. + pow(pos_ilum.w,7.1)*0.5);
                
                 
                float surfaceColor = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                
                currentColorRecivial += surfaceColor
                                    * ( lightColor * (1.0 - surfaceBrightness) + vec3(1.0) * surfaceBrightness )
                                        * min(max(color * storeColorStrength, vec3(0.0)),vec3(1.0));
                
                currentColorRecivial += currentColorRecivial;
                endColorResult += storeColorStrength * currentColorRecivial;
                storeColorStrength *= reflection;
                hit = 1.0;
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition) * ( reflection + 1.0) > MAX_DISTANCE) {
                break;
            }
        }
        if(hit == 0.0) {
            break;
        }
        hit = 0.0;
        dist = 0.0;
        prevPosition = curPosition + normalVector;
        curPosition = prevPosition;
        rayDirection = reflect(rayDirection, normalVector);
    }
    /*
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    if( ( uv.y>0.6 || uv.y<-0.7 ))
        return vec4(0.);
    if( (  uv.x>0.3 ) && distanceOfCollision>4.)
        return vec4(0.);
    else if( (  uv.x<-0.3 ) && distanceOfCollision>4.)
        return vec4(0.);
    else*/
        return vec4( endColorResult, 1.);
}


float resolveRaySphereIntersection(vec3 b, vec3 c, vec3 dir){
    vec3 OC=b-c;
    float P=dot(OC,dir);
    if(P<0.) return 1111.0;
    float d=sqrt(pow(length(OC),2.0)-pow(P,2.0));
    return d;
}
float trace(vec3 rayOrigin, vec3 rayDirection) {
    return resolveRaySphereIntersection(vec3(0.0,3.0,2.0), rayOrigin, rayDirection)*3.0;
}
vec4 mainImage( vec2 fragCoord ) {  
        vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
        float aspect = iResolution.x / iResolution.y;
        vec3 cameraPosition = vec3( 0., 4., 12.);
        vec3 direction = normalize( vec3(.5 * uv * vec2( aspect, 1.0), 1. ) );
        direction *= rotationMatrix(vec3(1.0,0.0,0.0), 0.4);
        cameraPosition *= rotationMatrix(vec3(0.0,1.0,0.0), -iGlobalTime*4.0+10.0*(rand(vec2(floor(iGlobalTime*6.0)))));
        direction *= rotationMatrix(vec3(0.0,1.0,0.0), iGlobalTime*4.0+10.0*(rand(vec2(floor(iGlobalTime*6.0)))));
        direction.z *= -1.0;
    
        vec4 color = march( cameraPosition, direction);
        color.rgb = pow(color.rgb, vec3(1./2.1));

        return color;
    
        
}

void main() {
  vec2 uv = gl_FragCoord.xy / iResolution.xy*2.0-1.0;
  vec4 fragColor;
  gl_FragColor = (3.0*mainImage( gl_FragCoord.xy ) + 0.3*vec4((1.3*rand(vec2(floor(gl_FragCoord*4.0*iGlobalTime))))) + floor(1.5*rand((121.0*iGlobalTime)))*vec4(1.0,0.0,0.0,1.0) + floor(1.5*rand((21.0*iGlobalTime)))*vec4(0.0,0.0,1.0,1.0))*(1.-length(gl_FragCoord.xy/iResolution.xy-.5)/1.62);
}